
////////////////////////////////////////////////////////////
//	File:		"AnimationManager.h"
//	Author:		[JW] Jason Ware
//	Modified:	[JW] November 17, 2008
//	Purpose:	The manager for all animations in the game.
//				- Singleton
////////////////////////////////////////////////////////////

#ifndef ANIMATIONMANAGER_H_
#define ANIMATIONMANAGER_H_

#include "Sprite.h"

class ifstream;

class CAnimationManager
{

public:

	/* Public Data Members */

protected:

	/* Protected Data Members */

private:

	vector<CSprite*>						m_vSpriteSheets;	// Holds all the sprite sheets in the game

	/* Private Data Members */
	static CAnimationManager				sm_Instance;

	/* Disabled Functions */
	CAnimationManager(const CAnimationManager& C);
	CAnimationManager& operator=(const CAnimationManager& C);

public:

	////////////////////////////////////////////////////////////
	//	Function:	Accessors
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Gets the specified type.
	////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////
	//	Function:	Mutators
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Sets the specified type.
	////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////
	//	Function:	GetInstance
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Returns the singleton's instance.
	////////////////////////////////////////////////////////////
	static CAnimationManager* GetInstance();

	////////////////////////////////////////////////////////////
	//	Function:	GetSpriteSheet
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Returns a specified sprite sheet.
	////////////////////////////////////////////////////////////
	CSprite* GetSpriteSheet(const string szSpriteName);

	////////////////////////////////////////////////////////////
	//	Function:	LoadAnimations
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Loads animations for a given sprite sheet.
	////////////////////////////////////////////////////////////
	bool LoadAnimations(const string szFile);

	////////////////////////////////////////////////////////////
	//	Function:	ShutdownAnimationManager
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Releases all memory allocated by manager.
	////////////////////////////////////////////////////////////
	void ShutdownAnimationManager(void);

protected:

	/* Protected Functions */

private:

	/* Private Functions */

	////////////////////////////////////////////////////////////
	//	Function:	Constructor
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Initializes the object.
	////////////////////////////////////////////////////////////
	CAnimationManager();

	////////////////////////////////////////////////////////////
	//	Function:	Destructor
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Deallocates the object.
	////////////////////////////////////////////////////////////
	~CAnimationManager();

	////////////////////////////////////////////////////////////
	//	Function:	GetAnchor
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Helper method to obtain the anchor from 
	//					the file.
	////////////////////////////////////////////////////////////
	void GetAnchor(std::ifstream &ifs, const int nAnimIndex, const int nFrameIndex);

	////////////////////////////////////////////////////////////
	//	Function:	GetRect
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Helper method to obtain the rect from 
	//					the file.
	////////////////////////////////////////////////////////////
	RECT GetRect(std::ifstream &ifs);

};

#endif
